console.log('just testin...');
const {BrowserWindow, Menu, app, shell, dialog} = require('electron');
module.exports.randomValue = "dogs";
let devBuild = false;

const name = app.getName();

let template = [{
  label: 'Edit',
  submenu: [{
    label: 'Undo',
    accelerator: 'CmdOrCtrl+Z',
    role: 'undo'
  }, {
    label: 'Redo',
    accelerator: 'Shift+CmdOrCtrl+Z',
    role: 'redo'
  }, {
    type: 'separator'
  }, {
    label: 'Cut',
    accelerator: 'CmdOrCtrl+X',
    role: 'cut'
  }, {
    label: 'Copy',
    accelerator: 'CmdOrCtrl+C',
    role: 'copy'
  }, {
    label: 'Paste',
    accelerator: 'CmdOrCtrl+V',
    role: 'paste'
  }, {
    label: 'Select All',
    accelerator: 'CmdOrCtrl+A',
    role: 'selectall'
  }]
}, {
  label: 'View',
  submenu: [{
    label: 'Reload App Window',
    visible: false,
    accelerator: 'CmdOrCtrl+R',
    click: (item, focusedWindow) => {
      if (focusedWindow) {
        // on reload, start fresh and close any old
        // open secondary windows
        if (focusedWindow.id === 1) {
          BrowserWindow.getAllWindows().forEach(win => {
            if (win.id > 1) win.close()
          })
        }
        focusedWindow.reload()
      }
    }
  }, {
    label: 'Toggle Full Screen',
    visible: false,
    accelerator: (() => {
      if (process.platform === 'darwin') {
        return 'Ctrl+Command+F'
      } else {
        return 'F11'
      }
    })(),
    click: (item, focusedWindow) => {
      if (focusedWindow) {
        focusedWindow.setFullScreen(!focusedWindow.isFullScreen())
      }
    }
  }, {
    label: 'Toggle Developer Tools',
  //visible: devBuild,
    accelerator: (() => {
      if (process.platform === 'darwin') {
        return 'Alt+Command+I'
      } else {
        return 'Ctrl+Shift+I'
      }
    })(),
    click: (item, focusedWindow) => {
      if (focusedWindow) {
        //focusedWindow.toggleDevTools({mode:'undocked'})
        //mainWindow.toggleDevTools({mode:'undocked'})
        mainWindow.webContents.openDevTools({mode:'undocked'})
      }
    }
  }, {
    type: 'separator',
    visible: false
  }, {
    label: 'App Menu Demo',
    visible: false,
    click: function (item, focusedWindow) {
      if (focusedWindow) {
        const nativeImage = require('electron').nativeImage
        let image = nativeImage.createFromPath(`${__dirname}/AlertInfoIcon.png`);

        // let arguments = process.argv.slice(2);
        // arguments.forEach(function(val,index, array) {
        //   console.log(index + ': ' + val);
        // });

        const options = {
          type: 'info',
          icon: image,
          title: 'Application Menu Demo',
          buttons: ['Neat', 'Still Neat'],
          //message: 'This demo is for the Menu section, showing how to create a clickable menu item in the application menu.'
          message: process.argv.toString().split(',')[1]
        }
        dialog.showMessageBox(focusedWindow, options, function () {})
      }
    }
  }]
}, {
  label: 'Window',
  role: 'window',
  submenu: [{
    label: 'Minimize',
    accelerator: 'CmdOrCtrl+M',
    role: 'minimize'
  }, {
    label: 'Close',
    accelerator: 'CmdOrCtrl+W',
    role: 'close'
  }, {
    type: 'separator'
  }, {
    label: 'Reopen Window',
    accelerator: 'CmdOrCtrl+Shift+T',
    enabled: false,
    key: 'reopenMenuItem',
    click: () => {
      app.emit('activate')
    }
  }]
}, {
  label: 'Help',
  role: 'help',
  submenu: [{
    label: 'Learn More',
    click: () => {
      shell.openExternal('http://cni-boston.org')
    }
  },{
    type: 'separator'
  },{
    label: `About ${name}`,
    // role: 'about'
    click: (item, focusedWindow) => {
      if (smallWindow === null) {
        createSmallWindow()
      } else {
          smallWindow.focus()
          smallWindow.flashFrame(true)
        }
      }
  }]
}]

function addUpdateMenuItems (items, position) {
  if (process.mas) return

  const version = app.getVersion()
  let updateItems = [{
    label: `Version ${version}`,
    enabled: false
  }, {
    label: 'Checking for Update',
    enabled: false,
    key: 'checkingForUpdate'
  }, {
    label: 'Check for Update',
    visible: false,
    key: 'checkForUpdate',
    click: () => {
      require('electron').autoUpdater.checkForUpdates()
    }
  }, {
    label: 'Restart and Install Update',
    enabled: true,
    visible: false,
    key: 'restartToUpdate',
    click: () => {
      require('electron').autoUpdater.quitAndInstall()
    }
  }]

  items.splice.apply(items, [position, 0].concat(updateItems))
}

function findReopenMenuItem () {
    const menu = Menu.getApplicationMenu()
    if (!menu) return
  
    let reopenMenuItem
    menu.items.forEach(item => {
      if (item.submenu) {
        item.submenu.items.forEach(item => {
          if (item.key === 'reopenMenuItem') {
            reopenMenuItem = item
          }
        })
      }
    })
    return reopenMenuItem
  }

if (process.platform === 'darwin') {
    //const name = app.getName()
    //template.push({
    template.unshift({
      label: name,
      submenu: [{
        label: `About ${name}`,
        // role: 'about'
        click: (item, focusedWindow) => {
          if (smallWindow === null) {
            createSmallWindow()
          } else {
              smallWindow.focus()
              smallWindow.flashFrame(true)
            }
          }
      }, {
        type: 'separator'
      }, {
        label: 'Services',
        role: 'services',
        submenu: []
      }, {
        type: 'separator'
      }, {
        label: `🛑 Reset ${name}`,
        accelerator: 'CmdOrCtrl+R',
        click: (item, focusedWindow) => {
            mainWindow.reload()
            }
      }, {
        type: 'separator'
      }, {
        label: `🌐 Use Server ${name} from cni29`,
        type: 'checkbox',
        checked: true,
        enabled: false,
        visible: devBuild,
        click: (item, focusedWindow) => {
            doTheThingIWant("cni29");
            }
      }, {
        //label: `🌐 Use Server ${name} from MSApps.org`,
        label: `🌐 Use Server ${name} from msApps`,
        key: 'msapps',
        type: 'checkbox',
        visible: devBuild,
        click: (item, focusedWindow) => {
            doTheThingIWant("msapps");
            }
      }, {
        type: 'separator',
        visible: devBuild,
      }, {
        label: `💟 Use Developer ${name} from ansibler`,
        type: 'checkbox',
        visible: devBuild,
        // checked: true,
        // enabled: false,
        click: (item, focusedWindow) => {
            doTheThingIWant("ansibler")
            }
      }, {
        label: `⚛️ Use Developer ${name} from localhost`,
        type: 'checkbox',
        visible: devBuild,
        click: (item, focusedWindow) => {
          doTheThingIWant("localhost")
            }
      }, {
        label: `⚠️ Use Staging ${name}`,
        type: 'checkbox',
        visible: devBuild,
        click: (item, focusedWindow) => {
            doTheThingIWant("custom")
            }
      }, {
        type: 'separator'
      }, {
        label: `Hide ${name}`,
        accelerator: 'Command+H',
        role: 'hide'
      }, {
        label: 'Hide Others',
        accelerator: 'Command+Alt+H',
        role: 'hideothers'
      }, {
        label: 'Show All',
        role: 'unhide'
      }, {
        type: 'separator'
      }, {
        label: 'Quit',
        accelerator: 'Command+Q',
        click: () => {
          app.quit()
        }
      }]
    })
  
    // Window menu.
    template[3].submenu.push({
      type: 'separator'
    }, {
      label: 'Bring All to Front',
      role: 'front'
    })
  
    //addUpdateMenuItems(template[0].submenu, 1)
  }
  
  // app menu test for windows
  if (process.platform === 'win32') {
  
  template.unshift({
    label: `Application`,
    submenu: [{
      label: `About ${name}`,
      // role: 'about'
      click: (item, focusedWindow) => {
        if (smallWindow === null) {
          createSmallWindow()
        } else {
            smallWindow.focus()
            smallWindow.flashFrame(true)
          }
        }
    }, {
      type: 'separator'
    }, {
      label: `☇ Reset ${name}`,
      click: (item, focusedWindow) => {
          mainWindow.reload()
          }
    }, {
      type: 'separator'
    }, {
      label: `☁︎ Use Server ${name} from cni29`,
      type: 'checkbox',
      checked: true,
      enabled: false,
      click: (item, focusedWindow) => {
          doTheThingIWant("cni29");
          }
    }, {
      label: `☁︎ Use Server ${name} from msApps`,
      key: 'msapps',
      type: 'checkbox',
      click: (item, focusedWindow) => {
          doTheThingIWant("msapps");
          }
    }, {
      type: 'separator'
    }, {
      label: `✦ Use Developer ${name} from ansibler`,
      type: 'checkbox',
      // checked: true,
      // enabled: false,
      click: (item, focusedWindow) => {
          doTheThingIWant("ansibler")
          }
    }, {
      label: `⚛︎ Use Developer ${name} from localhost`,
      type: 'checkbox',
      click: (item, focusedWindow) => {
        doTheThingIWant("localhost")
          }
    }, {
      label: `⚠ Use Staging ${name}`,
      type: 'checkbox',
      click: (item, focusedWindow) => {
          doTheThingIWant("custom")
          }
    }, {
      type: 'separator'
    }, {
      label: `Hide ${name}`,
      accelerator: 'Command+H',
      role: 'hide'
    }, {
      label: 'Hide Others',
      accelerator: 'Command+Alt+H',
      role: 'hideothers'
    }, {
      label: 'Show All',
      role: 'unhide'
    }, {
      type: 'separator'
    }, {
      label: 'Quit',
      accelerator: 'Command+Q',
      click: () => {
        app.quit()
      }
    }]
  })
  
  }
  
  
  if (process.platform === 'win32') {
    const helpMenu = template[template.length - 1].submenu
    addUpdateMenuItems(helpMenu, 0)
  }


  app.on('browser-window-created', () => {
    let reopenMenuItem = findReopenMenuItem()
    if (reopenMenuItem) reopenMenuItem.checked = true
  })
  
  app.on('window-all-closed', () => {
    let reopenMenuItem = findReopenMenuItem()
    if (reopenMenuItem) reopenMenuItem.enabled = true
  })


  function doTheThingIWant(myVar) {

    const menu = Menu.getApplicationMenu()
    let flags = "?token="+mytoken+"&version="+app.getVersion()+"&client="+computerName;
  
    // reset all disabled and checked menu items in App menu
    menu.items[0].submenu.items.forEach(item => {
          item.enabled = true
          item.checked = false
        })
  
    if(myVar == 'cni29'){
  
      mainWindow.loadURL("https://cni29.bwh.harvard.edu/d2/whereto.php"+flags);
      //mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/zz-7/concord/interface.html')
      menu.items[0].submenu.items[6].checked = true
      menu.items[0].submenu.items[6].enabled = false
    }
  
    if(myVar == 'msapps'){
      //mainWindow.loadURL('https://msapps.org/8cbb1fb0-85be-4f94-ab7b-b751f81aab4d/')
      mainWindow.loadURL("https://cni-boston.org/backup/whereto.php"+flags);
      menu.items[0].submenu.items[7].checked = true
      menu.items[0].submenu.items[7].enabled = false
    }
  
    if(myVar == 'ansibler'){
      if(computerName == "ansibler.local"){
        mainWindow.loadURL('https://ansibler.local/concord/'+flags);
        //mainWindow.loadURL(`file://${__dirname}/index.html`);
      } else if(computerName == "ansibler.partners.org" || computerName == "klopedia.partners.org"){
        mainWindow.loadURL('https://ansibler.partners.org/concord/'+flags);
      } else if(computerName == "klopedia.local"){
        mainWindow.loadURL('https://home.io:617/concord/'+flags);
      } else {
        mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/denied.html')
      }
  
      //mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/whereto.php?token='+mytoken+"&version="+app.getVersion());
      //mainWindow.loadURL('https://cni29.bwh.harvard.edu/d2/zz-5/concord/interface.html')
  
      //mainWindow.loadURL('https://home.io:617/concord/interface.html');
      //mainWindow.loadURL('https://10.0.0.11/concord/interface.html');  
  
      //mainWindow.loadURL('https://ansibler.local/concord/whereto.php?token='+mytoken+"&version="+app.getVersion());
      //mainWindow.loadURL('https://ansibler.local/concord/newer.html');
      //mainWindow.loadURL('https://ansibler.local/concord/nope.html');
      //mainWindow.loadURL('https://ansibler.partners.org/concord/interface.html');
      //mainWindow.loadURL('https://ansibler.local/concord/blank.html');
      menu.items[0].submenu.items[9].checked = true
      menu.items[0].submenu.items[9].enabled = false
    }
  
    if(myVar == 'ansibler-internal'){
      mainWindow.loadURL('https://ansibler.partners.org/concord/');
      menu.items[0].submenu.items[9].checked = true
      menu.items[0].submenu.items[9].enabled = false
    }
    
    if(myVar == 'localhost'){
      mainWindow.loadURL('https://localhost/concord/')
      menu.items[0].submenu.items[10].checked = true
      menu.items[0].submenu.items[10].enabled = false
    }
  
    if(myVar == 'custom'){
      mainWindow.loadURL("https://cni29.bwh.harvard.edu/d2/staging/concord/index.php"+flags);
      menu.items[0].submenu.items[11].checked = true
      menu.items[0].submenu.items[11].enabled = false
    }
  
  }